/**************************************************************
* HE FOLLOWING PROGRAM DEMOSTRATES TWO POSSIBLE BUGS WITHIN  *
* THE -OWER 128 LANGUAGE.  WOULD ASSUME THE BUGS ARE LOCAL *
* TO THE COMPILER OR TRANSLATOR, BUT DON'T KNOW A LOT ABOUT   *
* THE INTERNAL WORKINGS OF .                                 *
*                                                             *
*   UG 1: NEGATIVE VALUES ASSIGNED TO STATIC FLOATING POINT  *
*          VARIABLES WHEN DEFINED AREN'T STORED AS NEGATIVE   *
*          VALUES.                                            *
*                                                             *
*   UG 2: THE CONVERSION FROM A FLOAT TO AN INT DOESN'T WORK *
*          IT DOES, HOWEVER, WORK FOR FLOAT TO UNSIGNED OR    *
*          FLOAT TO INT IF THE (UNSIGNED) CAST IS USED.       *
*          SINCE IT IS UNSIGNED, THOUGH NEGATIVE FLOATS       *
*          CAUSE A RUNTIME ERROR.                             *
**************************************************************/

MAIN()

    STATIC FLOAT SF = -2.0;    /* OMPILER ? - OSES NEGATIVE SIGN */
    STATIC FLOAT LSF[] = -1.,-2.,-3.;   /	 SAME THING */
    UNSIGNED U;
    INT I;
    FLOAT F;

    PRINTF("SF= %F\N",SF);
    FOR (U=0; U<3; U++)
        PRINTF("LSF[%D]=%F\N",U,LSF[U]);

    SF = -3.9;                  /* NOTE THAT THIS WORKS */
    PRINTF("SF= %F\N",SF);

    F = 2.47;
    I = F;          /* OMPILER ? - ONVERSION DOESN'T WORK */
    PRINTF("I= %D\N",I);

    I = (INT) F;    /* STILL DOESN'T WORK */
    PRINTF("I= %D\N",I);

    I = (UNSIGNED) F;   /* THIS WORKS FOR ONLY F > 0 */
    PRINTF("I= %D\N",I);

    U = F;      	   /* THIS WORKS FOR ONLY F > 0 */
    PRINTF("U= %U\N",U);

    F = -F;
    I = (UNSIGNED) F;   /* THIS WON'T WORK NOW - STOPS W/RUNTIME ERROR */
    PRINTF("I= %D\N",I);

